<?php
require_once __DIR__ . '/includes/public_header.php';
require_once __DIR__ . '/includes/public_footer.php';

public_header(t('nav.news'));
?>
<h1 class="text-3xl font-bold tracking-tight"><?= htmlspecialchars(t('news.title')) ?></h1>
<p class="mt-3 text-slate-600 leading-7"><?= htmlspecialchars(t('news.desc')) ?></p>

<div class="mt-8 grid grid-cols-1 gap-4">
    <article class="rounded-2xl border border-slate-200 bg-white p-6">
        <div class="flex items-center justify-between">
            <h2 class="text-lg font-bold"><?= htmlspecialchars(t('news.sample')) ?></h2>
            <span class="text-xs font-semibold text-slate-500">2024–2025</span>
        </div>
        <p class="mt-2 text-sm text-slate-600 leading-6"><?= htmlspecialchars(t('news.sample_desc')) ?></p>
    </article>
    <article class="rounded-2xl border border-slate-200 bg-white p-6">
        <div class="flex items-center justify-between">
            <h2 class="text-lg font-bold"><?= htmlspecialchars(t('news.event')) ?></h2>
            <span class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('news.upcoming')) ?></span>
        </div>
        <p class="mt-2 text-sm text-slate-600 leading-6"><?= htmlspecialchars(t('news.event_desc')) ?></p>
    </article>
</div>
<?php
public_footer();
