<?php
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/includes/public_header.php';
require_once __DIR__ . '/includes/public_footer.php';
require_once __DIR__ . '/includes/i18n.php';

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    if (auth_login((string)$email, (string)$password)) {
        require_once __DIR__ . '/includes/toast.php';
        toast_set('success', t('login.welcome'));
        header('Location: /nyakinama/admin/index.php');
        exit;
    }

    $error = t('login.invalid');
}

public_header(t('login.title'));
?>
<div class="max-w-md mx-auto">
    <div class="rounded-3xl border border-slate-200 bg-white p-8 shadow-sm shadow-slate-900/5">
        <div class="inline-flex items-center gap-2 rounded-full border border-slate-200 bg-slate-50 px-3 py-1 text-xs font-semibold text-slate-700">
            <?= htmlspecialchars(t('login.admin_access')) ?>
        </div>
        <h1 class="mt-3 text-2xl font-bold tracking-tight"><?= htmlspecialchars(t('login.title')) ?></h1>
        <p class="mt-2 text-sm text-slate-600"><?= htmlspecialchars(t('login.subtitle')) ?></p>

        <?php if ($error): ?>
            <div class="mt-5 rounded-2xl border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-900">
                <div class="font-semibold"><?= htmlspecialchars(t('login.failed')) ?></div>
                <div class="mt-1 text-sm text-red-800"><?= htmlspecialchars($error) ?></div>
            </div>
        <?php endif; ?>

        <form class="mt-6 space-y-4" method="post" action="/nyakinama/login.php">
            <div>
                <label class="block text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('login.email')) ?></label>
                <input class="mt-1 w-full rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm outline-none focus:ring-2 focus:ring-slate-900/20" type="email" name="email" placeholder="nyakinama@gmail.com" value="<?= htmlspecialchars((string)($_POST['email'] ?? '')) ?>" required />
            </div>
            <div>
                <label class="block text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('login.password')) ?></label>
                <input class="mt-1 w-full rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm outline-none focus:ring-2 focus:ring-slate-900/20" type="password" name="password" placeholder="••••••••" required />
            </div>

            <button class="w-full rounded-xl bg-gradient-to-r from-slate-900 to-indigo-900 px-4 py-3 text-sm font-semibold text-white shadow-sm shadow-slate-900/10 hover:from-slate-800 hover:to-indigo-800" type="submit"><?= htmlspecialchars(t('login.submit')) ?></button>

            <div class="text-xs text-slate-500 leading-5">
                Roles planned: Admin, Accountant, Viewer/Auditor. Authentication logic will be wired later.
            </div>
        </form>
    </div>
</div>
<?php
public_footer();
