<?php
require_once __DIR__ . '/includes/public_header.php';
require_once __DIR__ . '/includes/public_footer.php';

public_header(t('nav.home'));
?>
<section class="grid grid-cols-1 lg:grid-cols-12 gap-8 items-start">
    <div class="lg:col-span-7">
        <div class="inline-flex items-center gap-2 rounded-full border border-slate-200 bg-white px-3 py-1 text-xs font-semibold text-slate-700">
            <span class="h-2 w-2 rounded-full bg-emerald-500"></span>
            <?= htmlspecialchars(t('home.badge')) ?>
        </div>
        <h1 class="mt-4 text-4xl sm:text-5xl font-bold tracking-tight text-slate-900"><?= htmlspecialchars(t('home.hero_title')) ?></h1>
        <p class="mt-4 text-lg text-slate-600"><?= htmlspecialchars(t('home.hero_desc')) ?></p>

        <div class="mt-6 flex flex-col sm:flex-row gap-3">
            <a href="/nyakinama/login.php" class="inline-flex items-center justify-center rounded-lg bg-slate-900 px-5 py-3 text-sm font-semibold text-white hover:bg-slate-800"><?= htmlspecialchars(t('public.go_to_dashboard')) ?></a>
            <a href="/nyakinama/services.php" class="inline-flex items-center justify-center rounded-lg border border-slate-300 bg-white px-5 py-3 text-sm font-semibold text-slate-900 hover:bg-slate-50"><?= htmlspecialchars(t('public.explore_services')) ?></a>
        </div>

        <div class="mt-10 grid grid-cols-1 sm:grid-cols-3 gap-4">
            <div class="rounded-2xl border border-slate-200 bg-white p-5">
                <div class="text-sm font-semibold text-slate-600"><?= htmlspecialchars(t('home.stat.budget')) ?></div>
                <div class="mt-1 text-2xl font-bold text-slate-900">42,155,213</div>
                <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('home.stat.budget_note')) ?></div>
            </div>
            <div class="rounded-2xl border border-slate-200 bg-white p-5">
                <div class="text-sm font-semibold text-slate-600"><?= htmlspecialchars(t('home.stat.projects')) ?></div>
                <div class="mt-1 text-2xl font-bold text-slate-900">—</div>
                <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('home.stat.projects_note')) ?></div>
            </div>
            <div class="rounded-2xl border border-slate-200 bg-white p-5">
                <div class="text-sm font-semibold text-slate-600"><?= htmlspecialchars(t('home.stat.years')) ?></div>
                <div class="mt-1 text-2xl font-bold text-slate-900">2024–2025</div>
                <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('home.stat.years_note')) ?></div>
            </div>
        </div>
    </div>

    <div class="lg:col-span-5">
        <div class="rounded-3xl border border-slate-200 bg-gradient-to-br from-white to-slate-50 p-6">
            <h2 class="text-lg font-bold text-slate-900"><?= htmlspecialchars(t('home.mission_vision')) ?></h2>
            <div class="mt-4 space-y-4 text-sm text-slate-600 leading-6">
                <p><span class="font-semibold text-slate-900"><?= htmlspecialchars(t('home.mission_label')) ?></span> <?= htmlspecialchars(t('home.mission_text')) ?></p>
                <p><span class="font-semibold text-slate-900"><?= htmlspecialchars(t('home.vision_label')) ?></span> <?= htmlspecialchars(t('home.vision_text')) ?></p>
            </div>
            <div class="mt-6 grid grid-cols-1 gap-3">
                <div class="rounded-2xl bg-white border border-slate-200 p-4">
                    <div class="text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('home.quick_links')) ?></div>
                    <div class="mt-2 flex flex-wrap gap-2">
                        <a class="rounded-full border border-slate-200 bg-slate-50 px-3 py-1 text-xs font-semibold text-slate-700 hover:bg-slate-100" href="/nyakinama/about.php"><?= htmlspecialchars(t('nav.about')) ?></a>
                        <a class="rounded-full border border-slate-200 bg-slate-50 px-3 py-1 text-xs font-semibold text-slate-700 hover:bg-slate-100" href="/nyakinama/news.php"><?= htmlspecialchars(t('home.announcements')) ?></a>
                        <a class="rounded-full border border-slate-200 bg-slate-50 px-3 py-1 text-xs font-semibold text-slate-700 hover:bg-slate-100" href="/nyakinama/contact.php"><?= htmlspecialchars(t('nav.contact')) ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php
public_footer();
