<?php

function settings_file_path(): string {
    return __DIR__ . '/../data/settings.json';
}

function settings_defaults(): array {
    return [
        'language' => 'French',
        'admin_email' => 'nyakinama@gmail.com',
        'admin_password_hash' => password_hash('nyakinama@123', PASSWORD_DEFAULT),
    ];
}

function settings_get(): array {
    $path = settings_file_path();

    if (!is_file($path)) {
        $defaults = settings_defaults();
        settings_save($defaults);
        return $defaults;
    }

    $raw = file_get_contents($path);
    if ($raw === false) {
        $defaults = settings_defaults();
        return $defaults;
    }

    $data = json_decode($raw, true);
    if (!is_array($data)) {
        $defaults = settings_defaults();
        return $defaults;
    }

    $defaults = settings_defaults();
    return array_merge($defaults, $data);
}

function settings_save(array $settings): void {
    $path = settings_file_path();
    $dir = dirname($path);
    if (!is_dir($dir)) {
        mkdir($dir, 0777, true);
    }

    file_put_contents($path, json_encode($settings, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT), LOCK_EX);
}
