<?php

require_once __DIR__ . '/settings_store.php';

function i18n_language(): string {
    $settings = settings_get();
    $lang = (string)($settings['language'] ?? 'French');

    if (!in_array($lang, ['French', 'English', 'Kinyarwanda'], true)) {
        $lang = 'French';
    }

    return $lang;
}

function t(string $key): string {
    $lang = i18n_language();

    $dict = [
        'English' => [
            'nav.home' => 'Home',
            'nav.about' => 'About',
            'nav.services' => 'Services',
            'nav.news' => 'News',
            'nav.contact' => 'Contact',
            'nav.login' => 'Login',
            'nav.logout' => 'Logout',
            'public.go_to_dashboard' => 'Go to Dashboard',
            'public.explore_services' => 'Explore Services',
            'public.brand' => 'NYAKINAMA MANAGEMENT',
            'public.footer.rights' => 'All rights reserved.',
            'public.footer.tagline' => 'Built for financial management, planning and reporting.',

            'home.badge' => 'Financial Management & Reporting',
            'home.hero_title' => 'Nyakinama Management',
            'home.hero_desc' => 'A structured platform for budget planning, financial reporting, project monitoring and administrative support.',
            'home.stat.budget' => 'Budget',
            'home.stat.projects' => 'Projects',
            'home.stat.years' => 'Years',
            'home.stat.budget_note' => 'Example value (from synthesis)',
            'home.stat.projects_note' => 'Add project tracking later',
            'home.stat.years_note' => 'Financial year selector in dashboard',
            'home.mission_vision' => 'Mission & Vision',
            'home.mission_label' => 'Mission:',
            'home.vision_label' => 'Vision:',
            'home.mission_text' => 'Strengthen transparency, accountability and stewardship through structured financial management.',
            'home.vision_text' => 'A parish organization empowered with reliable financial planning, execution tracking, and compliant reporting.',
            'home.quick_links' => 'Quick links',
            'home.announcements' => 'Announcements',

            'about.title' => 'About Nyakinama',
            'about.desc' => 'This website presents the public information and a dashboard for internal financial management. The system is designed to match the parish budget synthesis templates and support planning and reporting.',
            'about.diocese' => 'Diocese Information',
            'about.diocese_desc' => 'Add diocesan background, location, and administrative information here.',
            'about.leadership' => 'Leadership & Administration',
            'about.leadership_desc' => 'Add leadership names and roles, organizational structure, and responsibilities.',
            'about.structure' => 'Organizational Structure',
            'about.admin' => 'Administration',
            'about.admin_desc' => 'Governance, records, approvals.',
            'about.finance' => 'Finance',
            'about.finance_desc' => 'Budgets, receipts, expenses, reporting.',
            'about.quick_actions' => 'Quick actions',
            'about.view_services' => 'View Services',

            'services.title' => 'Services',
            'services.desc' => 'Nyakinama Management supports structured financial workflows aligned to parish templates.',
            'services.fm' => 'Financial Management',
            'services.fm_desc' => 'Record receipts and expenses with categories and analysis.',
            'services.bp' => 'Budget Planning',
            'services.bp_desc' => 'Prepare annual budgets and compare planned vs actual.',
            'services.fr' => 'Financial Reporting',
            'services.fr_desc' => 'Generate budget synthesis and annual reports. Export to PDF/Excel.',
            'services.pm' => 'Project Monitoring',
            'services.pm_desc' => 'Track project spend against budgets (optional module).',
            'services.ready' => 'Ready to use the dashboard?',
            'services.cta' => 'Login to manage finances and reports',

            'news.title' => 'Announcements / News',
            'news.desc' => 'Publish financial announcements, parish notices, and events.',
            'news.sample' => 'Sample Announcement',
            'news.sample_desc' => 'This is a placeholder announcement. Later, you can manage posts in the admin dashboard.',
            'news.event' => 'Event Notice',
            'news.event_desc' => 'Placeholder for parish events and notices.',
            'news.upcoming' => 'Upcoming',

            'contact.title' => 'Contact Us',
            'contact.desc' => 'For inquiries, reach out via the information below or send a message using the form.',
            'contact.address' => 'Address',
            'contact.diocese_parish' => 'Diocese / Parish',
            'contact.phone_email' => 'Phone & Email',
            'contact.send_message' => 'Send a message',
            'contact.full_name' => 'Full Name',
            'contact.your_name' => 'Your name',
            'contact.your_email' => 'you@example.com',
            'contact.message' => 'Message',
            'contact.write_message' => 'Write your message...',
            'contact.send' => 'Send',

            'login.title' => 'Login',
            'login.subtitle' => 'Sign in to access the admin dashboard.',
            'login.email' => 'Email',
            'login.password' => 'Password',
            'login.submit' => 'Login',
            'login.admin_access' => 'Admin Access',
            'login.failed' => 'Login failed',
            'login.invalid' => 'Invalid email or password.',
            'login.welcome' => 'Welcome back. You are now signed in.',

            'admin.dashboard' => 'Dashboard Overview',
            'admin.overview' => 'Overview',
            'admin.receipts' => 'Receipts',
            'admin.expenses' => 'Expenses',
            'admin.budgets' => 'Budgets',
            'admin.reports' => 'Reports',
            'admin.planning' => 'Planning',
            'admin.users' => 'Users',
            'admin.settings' => 'Settings',
            'admin.year' => 'Year',
            'admin.apply' => 'Apply',
            'admin.back_to_website' => 'Back to website',
            'admin.total_budget' => 'Total Budget',
            'admin.total_receipts' => 'Total Receipts',
            'admin.total_expenses' => 'Total Expenses',
            'admin.remaining_balance' => 'Remaining Balance',
            'admin.by_categories' => 'By categories',
            'admin.quick_actions' => 'Quick actions',
            'admin.quick_actions_note' => 'UI placeholders (logic will be wired later)',
            'admin.add_receipt' => 'Add receipt',
            'admin.add_receipt_desc' => 'Record income, compare planned vs actual.',
            'admin.record_expense' => 'Record expense',
            'admin.record_expense_desc' => 'Attach proof (PDF/image), categorize and analyze.',
            'admin.generate_reports' => 'Generate reports',
            'admin.generate_reports_desc' => 'Budget synthesis, annual report, exports.',
            'admin.edit_planning' => 'Edit planning',
            'admin.edit_planning_desc' => 'Financial planning tables for 2025–2026.',
            'admin.status' => 'Status',
            'admin.treasury' => 'Treasury',
            'admin.banks_cash' => 'Banks + cash',
            'admin.receivables' => 'Receivables',
            'admin.debts' => 'Debts',
            'admin.logout' => 'Logout',

            'admin.dashboard_title' => 'Admin Dashboard',
            'admin.admin_label' => 'Admin',

            'common.save' => 'Save',
            'common.open' => 'Open',
            'common.filter' => 'Filter',
            'common.search' => 'Search...',
            'common.date' => 'Date',
            'common.category' => 'Category',
            'common.description' => 'Description',
            'common.amount' => 'Amount',
            'common.month' => 'Month',
            'common.actions' => 'Actions',
            'common.edit' => 'Edit',
            'common.delete' => 'Delete',
            'common.other' => 'Other',

            'receipts.title' => 'Receipts',
            'receipts.add' => 'Add receipt',
            'receipts.list' => 'Receipts list',
            'receipts.summary' => 'Summary',
            'receipts.monthly_summary' => 'Monthly summary',
            'receipts.planned_vs_actual' => 'Planned vs Actual',
            'receipts.placeholder_table' => 'Placeholder table',
            'receipts.placeholder_chart' => 'Placeholder chart/table',
            'receipts.details_placeholder' => 'Details',

            'expenses.title' => 'Expenses',
            'expenses.record' => 'Record expense',
            'expenses.list' => 'Expenses list',
            'expenses.analysis' => 'Analysis',
            'expenses.totals' => 'Totals',
            'expenses.by_category_month' => 'By category / month',
            'expenses.attachments' => 'Attachments',
            'expenses.proof_tracking' => 'Proof tracking',
            'expenses.proof' => 'Proof',
            'expenses.proof_label' => 'Proof (PDF/Image)',
            'expenses.details_placeholder' => 'Details',

            'budgets.title' => 'Budget Management',
            'budgets.create' => 'Create annual budget',
            'budgets.summary' => 'Budget summary',
            'budgets.totals' => 'Totals',
            'budgets.variance' => 'Variance',
            'budgets.planned' => 'Planned (Prévisions)',
            'budgets.actual' => 'Actual (Réalisations)',
            'budgets.variance_label' => 'Variance (Écart)',
            'budgets.realization' => '% Realization',
            'budgets.planned_vs_actual' => 'Planned vs Actual',
            'budgets.ecart_and_percent' => 'Écart and %',

            'reports.title' => 'Financial Reports',
            'reports.center' => 'Report center',
            'reports.export_pdf' => 'Export PDF',
            'reports.export_excel' => 'Export Excel',
            'reports.budget_synthesis' => 'Budget synthesis',
            'reports.budget_synthesis_desc' => 'Receipts / Expenses / Result / Treasury / Receivables / Debts',
            'reports.income_expense' => 'Income & Expense report',
            'reports.income_expense_desc' => 'Detailed receipts and expenses',
            'reports.annual_report' => 'Annual financial report',
            'reports.annual_report_desc' => 'End-of-year report template',
            'reports.audit_package' => 'Audit package',
            'reports.audit_package_desc' => 'Exports and supporting documents',
            'reports.exports' => 'Exports',
            'reports.printable' => 'Printable official format',
            'reports.spreadsheet' => 'Spreadsheet export for analysis',

            'planning.title' => 'Financial Planning',
            'planning.tables' => 'Planning tables',
            'planning.subtitle' => 'Editable planning for 2025–2026 (placeholder)',
            'planning.planned_receipts' => 'Planned receipts',
            'planning.planned_expenses' => 'Planned expenses',
            'planning.line' => 'Line',
            'planning.forecast_balance' => 'Forecast balance',
            'planning.forecast_desc' => 'Planned receipts - planned expenses',
            'planning.card_financial_2025_2026' => 'Financial Planning 2025-2026',
            'planning.card_financial_2025_2026_desc' => 'Budget preparation and planning overview for the year.',
            'planning.card_debts_receivables' => 'Debts & Receivables Report',
            'planning.card_debts_receivables_desc' => 'Track outstanding receivables and debts for reporting.',

            'planning.details_subtitle' => 'Detailed planning view for the selected year.',
            'planning.back' => 'Back',
            'planning.data_section_title' => 'Planning data',
            'planning.data_missing_note' => 'Please provide the spreadsheet numbers (Excel/CSV or clearer screenshots) so this table can be filled exactly.',

            'users.title' => 'User Management',
            'users.users' => 'Users',
            'users.roles_note' => 'Roles define which modules a user can access.',
            'users.add_user' => 'Add user',
            'users.name' => 'Name',
            'users.email' => 'Email',
            'users.role' => 'Role',
            'users.status' => 'Status',
            'users.active' => 'Active',
            'users.deactivate' => 'Deactivate',
            'users.role_summary' => 'Role summary',
            'users.full_control' => 'Full control',
            'users.finance_modules' => 'Finance modules',
            'users.read_only_reports' => 'Read-only reports',

            'settings.title' => 'System Settings',
            'settings.subtitle' => 'Update language, admin email, and password.',
            'settings.admin_email' => 'Admin email',
            'settings.language' => 'Language',
            'settings.change_password' => 'Change password',
            'settings.current_password' => 'Current password',
            'settings.new_password' => 'New password',
            'settings.confirm_password' => 'Confirm new password',
            'settings.leave_empty' => 'Leave new password empty to keep current password.',
            'settings.save_changes' => 'Save changes',
            'settings.cancel' => 'Cancel',
            'settings.updated_success' => 'Settings updated successfully.',
            'settings.section_title' => 'Admin account & system',
            'settings.update_failed' => 'Update failed',
            'settings.error_valid_email' => 'Please enter a valid admin email.',
            'settings.error_current_required' => 'Current password is required.',
            'settings.error_current_incorrect' => 'Current password is incorrect.',
            'settings.error_fill_both' => 'Please fill both new password and confirmation.',
            'settings.error_mismatch' => 'New password and confirmation do not match.',
            'settings.categories_management' => 'Categories management',
            'settings.category_placeholder' => 'Placeholder for category CRUD.',
            'settings.backup_restore' => 'Backup & restore',
            'settings.backup' => 'Backup',
            'settings.restore' => 'Restore',
            'settings.notes' => 'Notes',
            'settings.note_storage' => 'Admin email and password are now stored in a local JSON file.',
            'settings.note_relogin' => 'If you change the email/password, you must use the new credentials next time you log in.',
        ],
        'French' => [
            'nav.home' => 'Accueil',
            'nav.about' => 'À propos',
            'nav.services' => 'Services',
            'nav.news' => 'Actualités',
            'nav.contact' => 'Contact',
            'nav.login' => 'Connexion',
            'nav.logout' => 'Déconnexion',
            'public.go_to_dashboard' => 'Aller au tableau de bord',
            'public.explore_services' => 'Découvrir les services',
            'public.brand' => 'NYAKINAMA MANAGEMENT',
            'public.footer.rights' => 'Tous droits réservés.',
            'public.footer.tagline' => 'Conçu pour la gestion financière, la planification et les rapports.',

            'home.badge' => 'Gestion financière & rapports',
            'home.hero_title' => 'Nyakinama Management',
            'home.hero_desc' => 'Une plateforme structurée pour la planification budgétaire, les rapports financiers, le suivi des projets et l’appui administratif.',
            'home.stat.budget' => 'Budget',
            'home.stat.projects' => 'Projets',
            'home.stat.years' => 'Années',
            'home.stat.budget_note' => 'Valeur exemple (depuis la synthèse)',
            'home.stat.projects_note' => 'Ajouter le suivi des projets plus tard',
            'home.stat.years_note' => 'Sélecteur d’année financière dans le dashboard',
            'home.mission_vision' => 'Mission & Vision',
            'home.mission_label' => 'Mission :',
            'home.vision_label' => 'Vision :',
            'home.mission_text' => 'Renforcer la transparence, la redevabilité et la bonne gestion via une organisation financière structurée.',
            'home.vision_text' => 'Une paroisse outillée avec une planification fiable, un suivi d’exécution et des rapports conformes.',
            'home.quick_links' => 'Liens rapides',
            'home.announcements' => 'Annonces',

            'about.title' => 'À propos de Nyakinama',
            'about.desc' => 'Ce site présente les informations publiques et un tableau de bord pour la gestion financière interne. Le système est conçu pour correspondre aux modèles de synthèse budgétaire et soutenir la planification et les rapports.',
            'about.diocese' => 'Informations sur le diocèse',
            'about.diocese_desc' => 'Ajoutez ici l’historique, la localisation et les informations administratives du diocèse.',
            'about.leadership' => 'Leadership & administration',
            'about.leadership_desc' => 'Ajoutez les noms, rôles, structure organisationnelle et responsabilités.',
            'about.structure' => 'Structure organisationnelle',
            'about.admin' => 'Administration',
            'about.admin_desc' => 'Gouvernance, dossiers, validations.',
            'about.finance' => 'Finance',
            'about.finance_desc' => 'Budgets, recettes, dépenses, rapports.',
            'about.quick_actions' => 'Actions rapides',
            'about.view_services' => 'Voir les services',

            'services.title' => 'Services',
            'services.desc' => 'Nyakinama Management soutient des processus financiers structurés alignés aux modèles paroissiaux.',
            'services.fm' => 'Gestion financière',
            'services.fm_desc' => 'Enregistrer recettes et dépenses avec catégories et analyses.',
            'services.bp' => 'Planification budgétaire',
            'services.bp_desc' => 'Préparer les budgets annuels et comparer prévu vs réalisé.',
            'services.fr' => 'Rapports financiers',
            'services.fr_desc' => 'Générer synthèses et rapports annuels. Export PDF/Excel.',
            'services.pm' => 'Suivi des projets',
            'services.pm_desc' => 'Suivre les dépenses des projets par rapport au budget (optionnel).',
            'services.ready' => 'Prêt à utiliser le tableau de bord ?',
            'services.cta' => 'Connectez-vous pour gérer finances et rapports',

            'news.title' => 'Annonces / Actualités',
            'news.desc' => 'Publier des annonces financières, des notices paroissiales et des événements.',
            'news.sample' => 'Annonce exemple',
            'news.sample_desc' => 'Annonce fictive. Plus tard, vous pourrez gérer les posts dans le tableau de bord.',
            'news.event' => 'Avis d’événement',
            'news.event_desc' => 'Emplacement réservé pour les événements et notices.',
            'news.upcoming' => 'À venir',

            'contact.title' => 'Contact',
            'contact.desc' => 'Pour toute question, contactez-nous via les informations ci-dessous ou envoyez un message avec le formulaire.',
            'contact.address' => 'Adresse',
            'contact.diocese_parish' => 'Diocèse / Paroisse',
            'contact.phone_email' => 'Téléphone & Email',
            'contact.send_message' => 'Envoyer un message',
            'contact.full_name' => 'Nom complet',
            'contact.your_name' => 'Votre nom',
            'contact.your_email' => 'vous@exemple.com',
            'contact.message' => 'Message',
            'contact.write_message' => 'Écrivez votre message...',
            'contact.send' => 'Envoyer',

            'login.title' => 'Connexion',
            'login.subtitle' => 'Connectez-vous pour accéder au tableau de bord.',
            'login.email' => 'Email',
            'login.password' => 'Mot de passe',
            'login.submit' => 'Se connecter',
            'login.admin_access' => 'Accès Admin',
            'login.failed' => 'Échec de connexion',
            'login.invalid' => 'Email ou mot de passe invalide.',
            'login.welcome' => 'Bienvenue. Vous êtes maintenant connecté.',
            'admin.dashboard' => 'Aperçu du tableau de bord',
            'admin.overview' => 'Aperçu',
            'admin.receipts' => 'Recettes',
            'admin.expenses' => 'Dépenses',
            'admin.budgets' => 'Budgets',
            'admin.reports' => 'Rapports',
            'admin.planning' => 'Planification',
            'admin.users' => 'Utilisateurs',
            'admin.settings' => 'Paramètres',
            'admin.year' => 'Année',
            'admin.apply' => 'Appliquer',
            'admin.back_to_website' => 'Retour au site',
            'admin.total_budget' => 'Budget total',
            'admin.total_receipts' => 'Total des recettes',
            'admin.total_expenses' => 'Total des dépenses',
            'admin.remaining_balance' => 'Solde restant',
            'admin.by_categories' => 'Par catégories',
            'admin.quick_actions' => 'Actions rapides',
            'admin.quick_actions_note' => 'Éléments UI (logique à connecter plus tard)',
            'admin.add_receipt' => 'Ajouter une recette',
            'admin.add_receipt_desc' => 'Enregistrer un revenu, comparer prévu vs réalisé.',
            'admin.record_expense' => 'Enregistrer une dépense',
            'admin.record_expense_desc' => 'Joindre une preuve (PDF/image), catégoriser et analyser.',
            'admin.generate_reports' => 'Générer des rapports',
            'admin.generate_reports_desc' => 'Synthèse budgétaire, rapport annuel, exports.',
            'admin.edit_planning' => 'Modifier la planification',
            'admin.edit_planning_desc' => 'Tableaux de planification 2025–2026.',
            'admin.status' => 'Statut',
            'admin.treasury' => 'Trésorerie',
            'admin.banks_cash' => 'Banques + caisse',
            'admin.receivables' => 'Créances',
            'admin.debts' => 'Dettes',
            'admin.logout' => 'Déconnexion',

            'admin.dashboard_title' => 'Tableau de bord admin',
            'admin.admin_label' => 'Admin',

            'common.save' => 'Enregistrer',
            'common.open' => 'Ouvrir',
            'common.filter' => 'Filtrer',
            'common.search' => 'Rechercher...',
            'common.date' => 'Date',
            'common.category' => 'Catégorie',
            'common.description' => 'Description',
            'common.amount' => 'Montant',
            'common.month' => 'Mois',
            'common.actions' => 'Actions',
            'common.edit' => 'Modifier',
            'common.delete' => 'Supprimer',
            'common.other' => 'Autre',

            'receipts.title' => 'Recettes',
            'receipts.add' => 'Ajouter une recette',
            'receipts.list' => 'Liste des recettes',
            'receipts.summary' => 'Résumé',
            'receipts.monthly_summary' => 'Résumé mensuel',
            'receipts.planned_vs_actual' => 'Prévu vs Réalisé',
            'receipts.placeholder_table' => 'Table fictive',
            'receipts.placeholder_chart' => 'Graphique/table fictif',
            'receipts.details_placeholder' => 'Détails',

            'expenses.title' => 'Dépenses',
            'expenses.record' => 'Enregistrer une dépense',
            'expenses.list' => 'Liste des dépenses',
            'expenses.analysis' => 'Analyse',
            'expenses.totals' => 'Totaux',
            'expenses.by_category_month' => 'Par catégorie / mois',
            'expenses.attachments' => 'Pièces jointes',
            'expenses.proof_tracking' => 'Suivi des preuves',
            'expenses.proof' => 'Preuve',
            'expenses.proof_label' => 'Preuve (PDF/Image)',
            'expenses.details_placeholder' => 'Détails',

            'budgets.title' => 'Gestion des budgets',
            'budgets.create' => 'Créer le budget annuel',
            'budgets.summary' => 'Résumé du budget',
            'budgets.totals' => 'Totaux',
            'budgets.variance' => 'Écart',
            'budgets.planned' => 'Prévisions',
            'budgets.actual' => 'Réalisations',
            'budgets.variance_label' => 'Écart',
            'budgets.realization' => '% Réalisation',
            'budgets.planned_vs_actual' => 'Prévu vs Réalisé',
            'budgets.ecart_and_percent' => 'Écart et %',

            'reports.title' => 'Rapports financiers',
            'reports.center' => 'Centre des rapports',
            'reports.export_pdf' => 'Exporter PDF',
            'reports.export_excel' => 'Exporter Excel',
            'reports.budget_synthesis' => 'Synthèse budgétaire',
            'reports.budget_synthesis_desc' => 'Recettes / Dépenses / Résultat / Trésorerie / Créances / Dettes',
            'reports.income_expense' => 'Rapport recettes & dépenses',
            'reports.income_expense_desc' => 'Détail des recettes et des dépenses',
            'reports.annual_report' => 'Rapport financier annuel',
            'reports.annual_report_desc' => 'Modèle de rapport de fin d’année',
            'reports.audit_package' => 'Dossier d’audit',
            'reports.audit_package_desc' => 'Exports et pièces justificatives',
            'reports.exports' => 'Exports',
            'reports.printable' => 'Format officiel imprimable',
            'reports.spreadsheet' => 'Export tableur pour analyse',

            'planning.title' => 'Planification financière',
            'planning.tables' => 'Tableaux de planification',
            'planning.subtitle' => 'Planification modifiable pour 2025–2026 (placeholder)',
            'planning.planned_receipts' => 'Recettes prévues',
            'planning.planned_expenses' => 'Dépenses prévues',
            'planning.line' => 'Ligne',
            'planning.forecast_balance' => 'Solde prévisionnel',
            'planning.forecast_desc' => 'Recettes prévues - dépenses prévues',
            'planning.card_financial_2025_2026' => 'Planification financière 2025-2026',
            'planning.card_financial_2025_2026_desc' => 'Préparation du budget et aperçu de la planification annuelle.',
            'planning.card_debts_receivables' => 'RAPPORT DES DETTES & CREANCES',
            'planning.card_debts_receivables_desc' => 'Suivi des créances et des dettes pour le reporting.',

            'planning.details_subtitle' => 'Vue détaillée de la planification pour l’année sélectionnée.',
            'planning.back' => 'Retour',
            'planning.data_section_title' => 'Données de planification',
            'planning.data_missing_note' => 'Merci de fournir les chiffres du tableau (Excel/CSV ou captures plus nettes) pour remplir cette table exactement.',

            'users.title' => 'Gestion des utilisateurs',
            'users.users' => 'Utilisateurs',
            'users.roles_note' => 'Rôles : Admin, Comptable, Lecteur/Auditeur',
            'users.add_user' => 'Ajouter un utilisateur',
            'users.name' => 'Nom',
            'users.email' => 'Email',
            'users.role' => 'Rôle',
            'users.status' => 'Statut',
            'users.active' => 'Actif',
            'users.deactivate' => 'Désactiver',
            'users.role_summary' => 'Résumé des rôles',
            'users.full_control' => 'Contrôle total',
            'users.finance_modules' => 'Modules financiers',
            'users.read_only_reports' => 'Rapports en lecture seule',

            'settings.title' => 'Paramètres',
            'settings.subtitle' => 'Mettre à jour la langue, l’email admin et le mot de passe.',
            'settings.admin_email' => 'Email admin',
            'settings.language' => 'Langue',
            'settings.change_password' => 'Changer le mot de passe',
            'settings.current_password' => 'Mot de passe actuel',
            'settings.new_password' => 'Nouveau mot de passe',
            'settings.confirm_password' => 'Confirmer le nouveau mot de passe',
            'settings.leave_empty' => 'Laissez vide pour garder le mot de passe actuel.',
            'settings.save_changes' => 'Enregistrer',
            'settings.cancel' => 'Annuler',
            'settings.updated_success' => 'Paramètres mis à jour avec succès.',
            'settings.section_title' => 'Compte admin & système',
            'settings.update_failed' => 'Échec de mise à jour',
            'settings.error_valid_email' => 'Veuillez entrer un email admin valide.',
            'settings.error_current_required' => 'Le mot de passe actuel est requis.',
            'settings.error_current_incorrect' => 'Le mot de passe actuel est incorrect.',
            'settings.error_fill_both' => 'Veuillez renseigner le nouveau mot de passe et la confirmation.',
            'settings.error_mismatch' => 'Le nouveau mot de passe et la confirmation ne correspondent pas.',
            'settings.categories_management' => 'Gestion des catégories',
            'settings.category_placeholder' => 'Emplacement réservé pour la gestion des catégories.',
            'settings.backup_restore' => 'Sauvegarde & restauration',
            'settings.backup' => 'Sauvegarder',
            'settings.restore' => 'Restaurer',
            'settings.notes' => 'Notes',
            'settings.note_storage' => 'L’email et le mot de passe admin sont stockés dans un fichier JSON local.',
            'settings.note_relogin' => 'Si vous changez l’email/le mot de passe, vous devrez utiliser les nouveaux identifiants à la prochaine connexion.',
        ],
        'Kinyarwanda' => [
            'nav.home' => 'Ahabanza',
            'nav.about' => 'Ibyerekeye',
            'nav.services' => 'Serivisi',
            'nav.news' => 'Amakuru',
            'nav.contact' => 'Twandikire',
            'nav.login' => 'Injira',
            'nav.logout' => 'Sohoka',
            'public.go_to_dashboard' => 'Jya ku kibaho',
            'public.explore_services' => 'Reba serivisi',
            'public.brand' => 'NYAKINAMA MANAGEMENT',
            'public.footer.rights' => 'Uburenganzira bwose burabitswe.',
            'public.footer.tagline' => 'Yubakiwe imicungire y’imari, igenamigambi na raporo.',

            'home.badge' => 'Imicungire y’imari & Raporo',
            'home.hero_title' => 'Nyakinama Management',
            'home.hero_desc' => 'Urubuga rufasha igenamigambi ry’ingengo y’imari, raporo z’imari, gukurikirana imishinga n’ubuyobozi.',
            'home.stat.budget' => 'Ingengo y’imari',
            'home.stat.projects' => 'Imishinga',
            'home.stat.years' => 'Imyaka',
            'home.stat.budget_note' => 'Urugero (ruvuye muri raporo)',
            'home.stat.projects_note' => 'Tuzongeramo gukurikirana imishinga',
            'home.stat.years_note' => 'Guhitamo umwaka w’imari muri dashboard',
            'home.mission_vision' => 'Intego & Icyerekezo',
            'home.mission_label' => 'Intego:',
            'home.vision_label' => 'Icyerekezo:',
            'home.mission_text' => 'Kongera ubushishozi n’ubunyangamugayo mu micungire y’imari binyuze mu buryo buteguye.',
            'home.vision_text' => 'Paruwasi ifite igenamigambi ryizewe, gukurikirana ishyirwa mu bikorwa, na raporo zujuje ibisabwa.',
            'home.quick_links' => 'Ihuza ryihuse',
            'home.announcements' => 'Amatangazo',

            'about.title' => 'Ibyerekeye Nyakinama',
            'about.desc' => 'Uru rubuga rugaragaza amakuru rusange n’ikibaho cy’imicungire y’imari. Rwubakiwe kujyana n’imbonerahamwe ya raporo y’ingengo y’imari no gufasha igenamigambi na raporo.',
            'about.diocese' => 'Amakuru ya Diyoseze',
            'about.diocese_desc' => 'Shyiramo amateka, aho iherereye n’amakuru y’ubuyobozi ya diyoseze.',
            'about.leadership' => 'Ubuyobozi',
            'about.leadership_desc' => 'Shyiramo amazina n’inshingano z’ubuyobozi n’imiterere y’ishyirahamwe.',
            'about.structure' => 'Imiterere y’ubuyobozi',
            'about.admin' => 'Ubuyobozi',
            'about.admin_desc' => 'Imiyoborere, inyandiko, kwemeza.',
            'about.finance' => 'Imari',
            'about.finance_desc' => 'Ingengo y’imari, inyemezabwishyu, ibyakoreshejwe, raporo.',
            'about.quick_actions' => 'Ibyihuse',
            'about.view_services' => 'Reba serivisi',

            'services.title' => 'Serivisi',
            'services.desc' => 'Nyakinama Management ifasha uburyo bw’imicungire y’imari bujyanye n’imbonerahamwe z’itorero.',
            'services.fm' => 'Imicungire y’imari',
            'services.fm_desc' => 'Kwandika inyemezabwishyu n’ibyakoreshejwe, ubusesenguzi.',
            'services.bp' => 'Igenamigambi ry’ingengo y’imari',
            'services.bp_desc' => 'Gutegura ingengo y’imari no kugereranya ibyo wageneye n’ibikorwa.',
            'services.fr' => 'Raporo z’imari',
            'services.fr_desc' => 'Gukora raporo z’ingengo y’imari n’iz’umwaka. Gusohora PDF/Excel.',
            'services.pm' => 'Gukurikirana imishinga',
            'services.pm_desc' => 'Gukurikirana amafaranga y’imishinga (ihitamo).',
            'services.ready' => 'Witeguye gukoresha dashboard?',
            'services.cta' => 'Injira ucunge imari na raporo',

            'news.title' => 'Amatangazo / Amakuru',
            'news.desc' => 'Gutangaza amakuru y’imari, amatangazo ya paruwasi n’ibikorwa.',
            'news.sample' => 'Itangazo ry’icyitegererezo',
            'news.sample_desc' => 'Ni urugero. Nyuma uzashobora gucunga amatangazo muri dashboard.',
            'news.event' => 'Itangazo ry’igikorwa',
            'news.event_desc' => 'Aho gushyira amakuru y’ibikorwa n’amatangazo.',
            'news.upcoming' => 'Biri imbere',

            'contact.title' => 'Twandikire',
            'contact.desc' => 'Niba ufite ikibazo, twandikire ukoresheje amakuru akurikira cyangwa usige ubutumwa.',
            'contact.address' => 'Aderesi',
            'contact.diocese_parish' => 'Diyoseze / Paruwasi',
            'contact.phone_email' => 'Telefoni & Email',
            'contact.send_message' => 'Ohereza ubutumwa',
            'contact.full_name' => 'Amazina',
            'contact.your_name' => 'Izina ryawe',
            'contact.your_email' => 'wowe@example.com',
            'contact.message' => 'Ubutumwa',
            'contact.write_message' => 'Andika ubutumwa...',
            'contact.send' => 'Ohereza',

            'login.title' => 'Injira',
            'login.subtitle' => 'Injira kugira ngo ugere ku kibaho cy’ubuyobozi.',
            'login.email' => 'Email',
            'login.password' => 'Ijambo ry’ibanga',
            'login.submit' => 'Injira',
            'login.admin_access' => 'Uburenganzira bw’ubuyobozi',
            'login.failed' => 'Ntibyagenze',
            'login.invalid' => 'Email cyangwa ijambo ry’ibanga si byo.',
            'login.welcome' => 'Murakaza neza. Mwinjiye neza.',
            'admin.dashboard' => 'Incamake',
            'admin.overview' => 'Incamake',
            'admin.receipts' => 'Inyemezabwishyu',
            'admin.expenses' => 'Ibisohoka',
            'admin.budgets' => 'Ingengo y’imari',
            'admin.reports' => 'Raporo',
            'admin.planning' => 'Igenamigambi',
            'admin.users' => 'Abakoresha',
            'admin.settings' => 'Igenamiterere',
            'admin.year' => 'Umwaka',
            'admin.apply' => 'Emeza',
            'admin.back_to_website' => 'Subira ku rubuga',
            'admin.total_budget' => 'Ingengo y’imari yose',
            'admin.total_receipts' => 'Inyemezabwishyu zose',
            'admin.total_expenses' => 'Ibisohoka byose',
            'admin.remaining_balance' => 'Asigaye',
            'admin.by_categories' => 'Ukurikije ibyiciro',
            'admin.quick_actions' => 'Ibyihuse',
            'admin.quick_actions_note' => 'UI gusa (logic izongerwamo)',
            'admin.add_receipt' => 'Ongeramo inyemezabwishyu',
            'admin.add_receipt_desc' => 'Kwandika amafaranga yinjiye, kugereranya ibyagenwe n’ibikorwa.',
            'admin.record_expense' => 'Kwandika igikoreshejwe',
            'admin.record_expense_desc' => 'Shyiraho inyandiko (PDF/ifoto), shyira mu cyiciro, usesengure.',
            'admin.generate_reports' => 'Kora raporo',
            'admin.generate_reports_desc' => 'Raporo y’ingengo y’imari, raporo y’umwaka, exports.',
            'admin.edit_planning' => 'Hindura igenamigambi',
            'admin.edit_planning_desc' => 'Imbonerahamwe z’igenamigambi 2025–2026.',
            'admin.status' => 'Imiterere',
            'admin.treasury' => 'Trésorerie',
            'admin.banks_cash' => 'Banki + cash',
            'admin.receivables' => 'Ababereyemo',
            'admin.debts' => 'Amadeni',
            'admin.logout' => 'Sohoka',

            'admin.dashboard_title' => 'Dashboard y’ubuyobozi',
            'admin.admin_label' => 'Admin',

            'common.save' => 'Bika',
            'common.open' => 'Fungura',
            'common.filter' => 'Shungura',
            'common.search' => 'Shakisha...',
            'common.date' => 'Itariki',
            'common.category' => 'Icyiciro',
            'common.description' => 'Ibisobanuro',
            'common.amount' => 'Amafaranga',
            'common.month' => 'Ukwezi',
            'common.actions' => 'Ibikorwa',
            'common.edit' => 'Hindura',
            'common.delete' => 'Siba',
            'common.other' => 'Ibindi',

            'receipts.title' => 'Inyemezabwishyu',
            'receipts.add' => 'Ongeramo inyemezabwishyu',
            'receipts.list' => 'Urutonde rw’inyemezabwishyu',
            'receipts.summary' => 'Incamake',
            'receipts.monthly_summary' => 'Incamake y’ukwezi',
            'receipts.planned_vs_actual' => 'Ibyagenwe vs ibyakozwe',
            'receipts.placeholder_table' => 'Imbonerahamwe y’icyitegererezo',
            'receipts.placeholder_chart' => 'Imbonerahamwe/ishusho y’icyitegererezo',
            'receipts.details_placeholder' => 'Ibisobanuro',

            'expenses.title' => 'Ibisohoka',
            'expenses.record' => 'Kwandika igikoreshejwe',
            'expenses.list' => 'Urutonde rw’ibisohoka',
            'expenses.analysis' => 'Isesengura',
            'expenses.totals' => 'Igiteranyo',
            'expenses.by_category_month' => 'Ukurikije icyiciro / ukwezi',
            'expenses.attachments' => 'Inyandiko',
            'expenses.proof_tracking' => 'Gukurikirana ibyemezo',
            'expenses.proof' => 'Icyemezo',
            'expenses.proof_label' => 'Icyemezo (PDF/Ifoto)',
            'expenses.details_placeholder' => 'Ibisobanuro',

            'budgets.title' => 'Ingengo y’imari',
            'budgets.create' => 'Tegura ingengo y’imari y’umwaka',
            'budgets.summary' => 'Incamake y’ingengo y’imari',
            'budgets.totals' => 'Igiteranyo',
            'budgets.variance' => 'Itandukaniro',
            'budgets.planned' => 'Ibyateganyijwe',
            'budgets.actual' => 'Ibyakozwe',
            'budgets.variance_label' => 'Itandukaniro',
            'budgets.realization' => '% Igeragezwa',
            'budgets.planned_vs_actual' => 'Ibyagenwe vs ibyakozwe',
            'budgets.ecart_and_percent' => 'Itandukaniro na %',

            'reports.title' => 'Raporo z’imari',
            'reports.center' => 'Ahakorerwa raporo',
            'reports.export_pdf' => 'Sohora PDF',
            'reports.export_excel' => 'Sohora Excel',
            'reports.budget_synthesis' => 'Incamake y’ingengo y’imari',
            'reports.budget_synthesis_desc' => 'Inyemezabwishyu / Ibisohoka / Ibisubizo / Trésorerie / Ababereyemo / Amadeni',
            'reports.income_expense' => 'Raporo y’inyemezabwishyu n’ibisohoka',
            'reports.income_expense_desc' => 'Ibisobanuro birambuye by’inyemezabwishyu n’ibisohoka',
            'reports.annual_report' => 'Raporo y’umwaka',
            'reports.annual_report_desc' => 'Inyandiko y’icyitegererezo isoza umwaka',
            'reports.audit_package' => 'Dosiye y’audit',
            'reports.audit_package_desc' => 'Ibisohoka n’inyandiko z’inyongera',
            'reports.exports' => 'Ibisohoka',
            'reports.printable' => 'Ifishi icapurwa',
            'reports.spreadsheet' => 'Excel yo gusesengura',

            'planning.title' => 'Igenamigambi ry’imari',
            'planning.tables' => 'Imbonerahamwe z’igenamigambi',
            'planning.subtitle' => 'Igenamigambi rihindurwa rya 2025–2026 (placeholder)',
            'planning.planned_receipts' => 'Inyemezabwishyu ziteganyijwe',
            'planning.planned_expenses' => 'Ibisohoka biteganyijwe',
            'planning.line' => 'Umurongo',
            'planning.forecast_balance' => 'Ibisigaye biteganyijwe',
            'planning.forecast_desc' => 'Inyemezabwishyu ziteganyijwe - ibisohoka biteganyijwe',
            'planning.card_financial_2025_2026' => 'Igenamigambi ry’imari 2025-2026',
            'planning.card_financial_2025_2026_desc' => 'Gutegura ingengo y’imari n’incamake y’igenamigambi ry’umwaka.',
            'planning.card_debts_receivables' => 'Raporo y’imyenda n’ibirarane',
            'planning.card_debts_receivables_desc' => 'Gukurikirana ibirarane n’imyenda mu rwego rwa raporo.',

            'planning.details_subtitle' => 'Urupapuro rurambuye rw’igenamigambi ry’umwaka watoranyijwe.',
            'planning.back' => 'Subira inyuma',
            'planning.data_section_title' => 'Iby’igenamigambi',
            'planning.data_missing_note' => 'Ohereza imibare yo muri spreadsheet (Excel/CSV cyangwa amafoto asobanutse) kugira ngo iyi mbonerahamwe yuzuzwe neza.',

            'users.title' => 'Ubuyobozi bw’abakoresha',
            'users.users' => 'Abakoresha',
            'users.roles_note' => 'Inshingano zigena imodoka umukoresha ashobora gukoresha.',
            'users.add_user' => 'Ongeraho umukoresha',
            'users.name' => 'Izina',
            'users.email' => 'Email',
            'users.role' => 'Inshingano',
            'users.status' => 'Imiterere',
            'users.active' => 'Ari gukora',
            'users.deactivate' => 'Hagarika',
            'users.role_summary' => 'Incamake y’inshingano',
            'users.full_control' => 'Kugenzura byose',
            'users.finance_modules' => 'Ibice by’imari',
            'users.read_only_reports' => 'Raporo zo gusoma gusa',

            'settings.title' => 'Igenamiterere',
            'settings.subtitle' => 'Hindura ururimi, email y’admin n’ijambo ry’ibanga.',
            'settings.admin_email' => 'Email ya admin',
            'settings.language' => 'Ururimi',
            'settings.change_password' => 'Hindura ijambo ry’ibanga',
            'settings.current_password' => 'Ijambo ry’ibanga rikoreshwa',
            'settings.new_password' => 'Ijambo rishya',
            'settings.confirm_password' => 'Emeza ijambo rishya',
            'settings.leave_empty' => 'Siga ubusa niba utashaka kurihindura.',
            'settings.save_changes' => 'Bika impinduka',
            'settings.cancel' => 'Hagarika',
            'settings.updated_success' => 'Igenamiterere ryavuguruwe neza.',
            'settings.section_title' => 'Konti ya admin & sisitemu',
            'settings.update_failed' => 'Kuvugurura byanze',
            'settings.error_valid_email' => 'Shyiramo email ya admin yemewe.',
            'settings.error_current_required' => 'Ijambo ry’ibanga rikoreshwa rirakenewe.',
            'settings.error_current_incorrect' => 'Ijambo ry’ibanga rikoreshwa si ryo.',
            'settings.error_fill_both' => 'Uzuza ijambo rishya n’iryemeza byombi.',
            'settings.error_mismatch' => 'Ijambo rishya n’iryemeza ntibihuye.',
            'settings.categories_management' => 'Gucunga ibyiciro',
            'settings.category_placeholder' => 'Aho gushyira CRUD y’ibyiciro.',
            'settings.backup_restore' => 'Kubika & kugarura',
            'settings.backup' => 'Bika',
            'settings.restore' => 'Garura',
            'settings.notes' => 'Ibisobanuro',
            'settings.note_storage' => 'Email n’ijambo ry’ibanga bya admin bibikwa muri JSON yo kuri mudasobwa.',
            'settings.note_relogin' => 'Nuhindura email/ijambo ry’ibanga, uzakoresha ibishya ku kwinjira ubutaha.',
        ],
    ];

    $value = $dict[$lang][$key] ?? $dict['English'][$key] ?? $key;
    return $value;
}
