<?php
require_once __DIR__ . '/../../includes/tailwind.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/toast.php';
require_once __DIR__ . '/../../includes/i18n.php';

function admin_nav_items(): array {
    return [
        ['label' => t('admin.overview'), 'href' => '/nyakinama/admin/index.php'],
        ['label' => t('admin.receipts'), 'href' => '/nyakinama/admin/receipts.php'],
        ['label' => t('admin.expenses'), 'href' => '/nyakinama/admin/expenses.php'],
        ['label' => t('admin.budgets'), 'href' => '/nyakinama/admin/budgets.php'],
        ['label' => t('admin.reports'), 'href' => '/nyakinama/admin/reports.php'],
        ['label' => t('admin.planning'), 'href' => '/nyakinama/admin/planning.php'],
        ['label' => t('admin.settings'), 'href' => '/nyakinama/admin/settings.php'],
    ];
}

function admin_header(string $title): void {
    auth_require_login();
    $current = $_SERVER['REQUEST_URI'] ?? '';
    $year = $_GET['year'] ?? '2024-2025';
    $email = isset($_SESSION['auth_user']['email']) ? (string)$_SESSION['auth_user']['email'] : '';

    ?><!doctype html>
    <html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title><?= htmlspecialchars($title) ?> - Admin - Nyakinama</title>
        <?php tailwind_cdn(); ?>
    </head>
    <body class="min-h-screen bg-gradient-to-b from-slate-50 to-white text-slate-900">
        <?php toast_render(); ?>
        <div class="min-h-screen flex">
            <aside class="hidden lg:flex lg:flex-col lg:w-72 bg-white border-r border-slate-200">
                <div class="px-6 py-5 border-b border-slate-200">
                    <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('public.brand')) ?></div>
                    <div class="mt-1 text-lg font-bold tracking-tight"><?= htmlspecialchars(t('admin.dashboard_title')) ?></div>
                </div>
                <nav class="px-3 py-4 space-y-1">
                    <?php foreach (admin_nav_items() as $item):
                        $active = str_starts_with($current, parse_url($item['href'], PHP_URL_PATH) ?: $item['href']);
                        ?>
                        <a href="<?= htmlspecialchars($item['href']) ?>?year=<?= urlencode($year) ?>"
                           class="flex items-center justify-between rounded-xl px-4 py-3 text-sm font-semibold <?= $active ? 'bg-gradient-to-r from-slate-900 to-indigo-900 text-white shadow-sm shadow-slate-900/10' : 'text-slate-700 hover:bg-slate-100' ?>">
                            <span><?= htmlspecialchars($item['label']) ?></span>
                            <span class="text-xs <?= $active ? 'text-white/70' : 'text-slate-400' ?>">›</span>
                        </a>
                    <?php endforeach; ?>
                </nav>
                <div class="mt-auto p-4 border-t border-slate-200">
                    <a href="/nyakinama/index.php" class="block rounded-xl border border-slate-200 bg-slate-50 px-4 py-3 text-sm font-semibold text-slate-900 hover:bg-slate-100"><?= htmlspecialchars(t('admin.back_to_website')) ?></a>
                </div>
            </aside>

            <div class="flex-1">
                <header class="bg-white/90 backdrop-blur border-b border-slate-200 sticky top-0 z-40">
                    <div class="px-4 sm:px-6 py-4 flex items-center justify-between gap-4">
                        <div>
                            <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('admin.admin_label')) ?></div>
                            <div class="text-lg font-bold tracking-tight"><?= htmlspecialchars($title) ?></div>
                        </div>

                        <div class="flex items-center gap-3">
                            <form method="get" class="flex items-center gap-2">
                                <label class="text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('admin.year')) ?></label>
                                <select name="year" class="rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm font-semibold outline-none focus:ring-2 focus:ring-slate-900/20">
                                    <?php foreach (['2024-2025', '2025-2026'] as $y): ?>
                                        <option value="<?= htmlspecialchars($y) ?>" <?= $year === $y ? 'selected' : '' ?>><?= htmlspecialchars($y) ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <button class="rounded-xl bg-gradient-to-r from-slate-900 to-indigo-900 px-4 py-2 text-sm font-semibold text-white shadow-sm shadow-slate-900/10 hover:from-slate-800 hover:to-indigo-800" type="submit"><?= htmlspecialchars(t('admin.apply')) ?></button>
                            </form>

                            <div class="hidden sm:flex items-center gap-3">
                                <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars($email) ?></div>
                                <a href="/nyakinama/logout.php" class="inline-flex rounded-xl border border-slate-300 bg-white px-4 py-2 text-sm font-semibold text-slate-900 hover:bg-slate-50"><?= htmlspecialchars(t('admin.logout')) ?></a>
                            </div>
                        </div>
                    </div>
                </header>

                <main class="px-4 sm:px-6 py-8">
<?php
}

function admin_footer(): void {
    ?>
                </main>
            </div>
        </div>
    </body>
    </html>
<?php
}
