<?php
require_once __DIR__ . '/includes/admin_layout.php';

admin_header(t('budgets.title'));
$year = $_GET['year'] ?? '2024-2025';
?>
<div class="grid grid-cols-1 xl:grid-cols-12 gap-6">
    <section class="xl:col-span-8">
        <div class="rounded-3xl border border-slate-200 bg-white p-6">
            <div class="flex items-start justify-between gap-4">
                <div>
                    <div class="text-sm font-semibold"><?= htmlspecialchars(t('budgets.create')) ?></div>
                    <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('admin.year')) ?>: <?= htmlspecialchars($year) ?></div>
                </div>
                <button class="rounded-xl bg-slate-900 px-4 py-2 text-sm font-semibold text-white hover:bg-slate-800" type="button"><?= htmlspecialchars(t('common.save')) ?></button>
            </div>

            <div class="mt-6 overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left text-xs font-semibold text-slate-500">
                            <th class="py-2 pr-4"><?= htmlspecialchars(t('common.category')) ?></th>
                            <th class="py-2 pr-4"><?= htmlspecialchars(t('budgets.planned')) ?></th>
                            <th class="py-2 pr-4"><?= htmlspecialchars(t('budgets.actual')) ?></th>
                            <th class="py-2 pr-4"><?= htmlspecialchars(t('budgets.variance_label')) ?></th>
                            <th class="py-2 pr-4"><?= htmlspecialchars(t('budgets.realization')) ?></th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200">
                        <tr>
                            <td class="py-3 pr-4 font-semibold"><?= htmlspecialchars(t('cat.recettes_propres')) ?></td>
                            <td class="py-3 pr-4"><input class="w-40 rounded-lg border border-slate-300 px-3 py-2" placeholder="0" /></td>
                            <td class="py-3 pr-4"><input class="w-40 rounded-lg border border-slate-300 px-3 py-2" placeholder="0" /></td>
                            <td class="py-3 pr-4 font-semibold text-slate-600">—</td>
                            <td class="py-3 pr-4 text-slate-600">—</td>
                        </tr>
                        <tr>
                            <td class="py-3 pr-4 font-semibold"><?= htmlspecialchars(t('common.other')) ?></td>
                            <td class="py-3 pr-4"><input class="w-40 rounded-lg border border-slate-300 px-3 py-2" placeholder="0" /></td>
                            <td class="py-3 pr-4"><input class="w-40 rounded-lg border border-slate-300 px-3 py-2" placeholder="0" /></td>
                            <td class="py-3 pr-4 font-semibold text-slate-600">—</td>
                            <td class="py-3 pr-4 text-slate-600">—</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </section>

    <aside class="xl:col-span-4">
        <div class="rounded-3xl border border-slate-200 bg-white p-6">
            <div class="text-sm font-semibold"><?= htmlspecialchars(t('budgets.summary')) ?></div>
            <div class="mt-4 space-y-3 text-sm">
                <div class="rounded-2xl border border-slate-200 bg-slate-50 p-4">
                    <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('budgets.totals')) ?></div>
                    <div class="mt-1 text-slate-600"><?= htmlspecialchars(t('budgets.planned_vs_actual')) ?></div>
                </div>
                <div class="rounded-2xl border border-slate-200 bg-slate-50 p-4">
                    <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('budgets.variance')) ?></div>
                    <div class="mt-1 text-slate-600"><?= htmlspecialchars(t('budgets.ecart_and_percent')) ?></div>
                </div>
            </div>
        </div>
    </aside>
</div>
<?php
admin_footer();
