<?php
require_once __DIR__ . '/includes/public_header.php';
require_once __DIR__ . '/includes/public_footer.php';

public_header(t('nav.about'));
?>
<div class="grid grid-cols-1 lg:grid-cols-12 gap-8">
    <div class="lg:col-span-8">
        <h1 class="text-3xl font-bold tracking-tight"><?= htmlspecialchars(t('about.title')) ?></h1>
        <p class="mt-3 text-slate-600 leading-7"><?= htmlspecialchars(t('about.desc')) ?></p>

        <div class="mt-8 rounded-2xl border border-slate-200 bg-white p-6">
            <h2 class="text-lg font-bold"><?= htmlspecialchars(t('about.diocese')) ?></h2>
            <p class="mt-2 text-sm text-slate-600 leading-6"><?= htmlspecialchars(t('about.diocese_desc')) ?></p>
        </div>

        <div class="mt-4 rounded-2xl border border-slate-200 bg-white p-6">
            <h2 class="text-lg font-bold"><?= htmlspecialchars(t('about.leadership')) ?></h2>
            <p class="mt-2 text-sm text-slate-600 leading-6"><?= htmlspecialchars(t('about.leadership_desc')) ?></p>
        </div>

        <div class="mt-4 rounded-2xl border border-slate-200 bg-white p-6">
            <h2 class="text-lg font-bold"><?= htmlspecialchars(t('about.structure')) ?></h2>
            <div class="mt-3 grid grid-cols-1 sm:grid-cols-2 gap-4 text-sm">
                <div class="rounded-xl border border-slate-200 bg-slate-50 p-4">
                    <div class="font-semibold"><?= htmlspecialchars(t('about.admin')) ?></div>
                    <div class="mt-1 text-slate-600"><?= htmlspecialchars(t('about.admin_desc')) ?></div>
                </div>
                <div class="rounded-xl border border-slate-200 bg-slate-50 p-4">
                    <div class="font-semibold"><?= htmlspecialchars(t('about.finance')) ?></div>
                    <div class="mt-1 text-slate-600"><?= htmlspecialchars(t('about.finance_desc')) ?></div>
                </div>
            </div>
        </div>
    </div>

    <div class="lg:col-span-4">
        <div class="rounded-3xl border border-slate-200 bg-white p-6 sticky top-24">
            <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('about.quick_actions')) ?></div>
            <div class="mt-4 space-y-3">
                <a href="/nyakinama/services.php" class="block rounded-xl border border-slate-200 bg-slate-50 px-4 py-3 text-sm font-semibold text-slate-900 hover:bg-slate-100"><?= htmlspecialchars(t('about.view_services')) ?></a>
                <a href="/nyakinama/login.php" class="block rounded-xl bg-slate-900 px-4 py-3 text-sm font-semibold text-white hover:bg-slate-800"><?= htmlspecialchars(t('nav.login')) ?></a>
            </div>
        </div>
    </div>
</div>
<?php
public_footer();
